<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\GenerateUrl;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function store(Request $request)
    {
        try {
            $request->validate([
                'name' => 'required',
                'email' => 'required|email|unique:customers,email',
                'phone' => 'required|unique:customers,phone',
                'restaurant_id' => 'required',
                'token' => 'required|unique:customers,phone',
                'privacy_policy' => 'accepted',
                'terms' => 'accepted',
            ]);
            
           

            $customer =Customer::create([
                'name' => $request['name'],
                'token' => $request['token'],
                'email' => $request['email'],
                'phone' => $request['phone'],
                'location' => $request['location'],
                
                'restaurant_id' => $request['restaurant_id'],
                'privacy_policy' => $request->has('privacy_policy') ? 1 : 0,
                'terms' => $request->has('terms') ? 1 : 0,
            ]);
            
            
            session([
                'customer_id'    => $customer->id,
                'customer_name'  => $customer->name,
                'customer_email' => $customer->email,
                'customer_phone' => $customer->phone,
            ]);

                return redirect()->route('thank.you');
        } catch (Exception $exp) {
            return redirect()->back()->with('error', $exp->getMessage());
        }
    }

 public function thankYou()
{
          return view('thank-you');

}



}


