<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Order\OrderController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



Route::post('restaurant-login', [AuthController::class, 'restaurantLogin']);
Route::middleware('auth:sanctum')->group(function () {
    Route::post('logout', [AuthController::class, 'logout']);
    Route::post('create-order', [OrderController::class, 'store']);
    Route::get('get-orders', [OrderController::class, 'getOrders']);
    Route::get('delete-order/{order_id}', [OrderController::class, 'deleteOrder']);
    Route::get('check-status/{counter_id}', [DashboardController::class, 'checkStatus']);
    Route::get('get-color/{restaurantId}', [DashboardController::class, 'getColorCode']);
});
