
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Radio App Portal</title>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<style>
    .custom-alert {
        padding: 12px 20px;
        margin: 10px 0;
        border-radius: 6px;
        font-weight: 500;
        position: relative;
        animation: fadeIn 0.3s ease-in-out;
    }

    .custom-alert.success {
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }

    .custom-alert.error {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }

    .custom-alert.warning {
        background: #fff3cd;
        color: #856404;
        border: 1px solid #ffeeba;
    }

    .custom-alert .close-btn {
        position: absolute;
        top: 5px;
        right: 10px;
        cursor: pointer;
        font-weight: bold;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>

</head>
<body>

<div class="container">
<div class="header">
   <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" class="logo">
</div>
<div id="msg"></div>
<div class="form-header">
  <!-- Add Form -->
    <form id="restaurantForm">
        <input type="text" name="name" placeholder="Restaurant Name" required>
        <input type="number" name="r_number" placeholder="Restaurant Number" required>
        <button type="submit">➕ Add Restaurant</button>
    </form>

            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();">
                <?php echo e(__('Logout')); ?>

            </a>

            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                <?php echo csrf_field(); ?>
            </form>

</div>
  <!-- Table -->
  <div class="table-wrapper">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Restaurant Name</th>
          <th>Counter ID:</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody id="restaurantTbody">
        <?php $number=0; ?>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($number); ?></td>
                <td><?php echo e($user->restaurant->name); ?></td>
                <td><?php echo e($user->restaurant->r_number); ?></td>
                <td>
                    <label class="switch">
                        <input type="checkbox" class="restaurant_status" data-id="<?php echo e($user->restaurant->id); ?>"
                            <?php echo e($user->restaurant->status=='1' ? 'checked' : ''); ?>>
                        <span class="slider"></span>
                    </label>
                </td>
            </tr>
            <?php $number++; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>

   <!-- Pagination Controls -->
    <div class="pagination">
    <button onclick="prevPage()">Prev</button>
    <span id="paginationNumbers"></span>
    <button onclick="nextPage()">Next</button>
    </div>

  </div>
  </div>
</div>

<!-- Modal -->
<div class="modal" id="updateModal">
  <div class="modal-content">
    <h2 class="text-center">Update Restaurant</h2>
    <input type="text" placeholder="Restaurant Name">
    <input type="url" placeholder="Counter ID:">
    <button class="btn btn-warning" style="width:100%;">Save Changes</button>
    <button class="close-btn" onclick="closeModal()">Cancel</button>
  </div>
</div>


<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function(){

    $('#restaurantForm').submit(function(e){
        e.preventDefault();
        var formData = $(this).serialize();

        $.ajax({
            url: "<?php echo e(url('/create-restaurant')); ?>",
            method: "POST",
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    // ✅ Success Message
                    $("#msg").append(`
                        <div class="custom-alert success">
                            ⚠️ Restaurant added Successfully
                            <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                        </div>
                    `);

                    // ✅ Append new row in table
                    let restaurant = response.data;
                    let rowCount = $("#restaurantTbody tr").length + 1;

                    $("#restaurantTbody").append(`
                        <tr>
                            <td>${rowCount}</td>
                            <td>${restaurant.name}</td>
                            <td>${restaurant.r_number}</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" class="restaurant_status" data-id="${restaurant.id}" ${restaurant.status == '1' ? 'checked' : ''}>
                                    <span class="slider"></span>
                                </label>
                            </td>
                        </tr>
                    `);

                    // ✅ Reset form
                    $('#restaurantForm')[0].reset();
                }
            },
            error: function(xhr) {
                console.error("Error:", xhr.responseText);
                $("#msg").append(`
                    <div class="custom-alert warning">
                        ❌ Failed to add Restaurant
                        <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                    </div>
                `);
            }
        });
    });


        $('.restaurant_status').change(function() {
            let status = $(this).is(":checked") ? '1' : '0';
            let restaurantId = $(this).data('id');
            $.ajax({
                 url: "<?php echo e(url('/status-change')); ?>/" + status + "/" + restaurantId,
                type: "post",
                data: {
                    _token : '<?php echo e(csrf_token()); ?>',
                    status : status,
                    restaurantId : restaurantId,
                },
                success:function(response){
                    $("#msg").html(""); // purane alerts clear

                    if(response){
                        if(response.enable){
                            $("#msg").append(`
                                <div class="custom-alert success">
                                    ✅ Restaurant Enabled Successfully
                                    <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                                </div>
                            `);
                        } else {
                            $("#msg").append(`
                                <div class="custom-alert warning">
                                    ⚠️ Restaurant Disabled Successfully
                                    <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                                </div>
                            `);
                        }
                    } else {
                        $("#msg").append(`
                            <div class="custom-alert error">
                                ❌ Failed to Change Status
                                <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                            </div>
                        `);
                    }
                }
            });
        });
    });
</script>
</body>
</html>
<?php /**PATH C:\wamp64\www\lunchPad\resources\views/dashboard.blade.php ENDPATH**/ ?>